#include "MDRFxx_SFR.h"
#include "UartSystem.h"
#include "Main.h"
#include "Motor.h"
#include "PWM.h"

#if (Uart_Debug == 1)
xdata signed short Debug_A;
xdata signed short Debug_B;
xdata signed short Debug_C;
xdata signed short Debug_D;
xdata signed short Debug_E;
xdata signed short Debug_F;

xdata unsigned char TxFinish;
xdata unsigned char RxState;
xdata unsigned char Debug_TxCounter;
xdata unsigned char Debug_RxCounter;
xdata unsigned char Debug_PreRxCounter;
xdata unsigned char Debug_TxBuffer[20];
xdata unsigned char Debug_RxBuffer[20];
xdata unsigned char Debug_TxDataLen;

//unsigned short CheckSUM;
xdata unsigned char CheckSUMFlag;
xdata unsigned char RxTimeOutCount = 0;

xdata unsigned short UartCount = 4;
xdata unsigned char UartFlag = 0;

//======================================================================
/*
 * Name         : UART_definition 
 *
 * Synopsis     : void UART_DEFINITION(void)
 */
 
// formula : (1024 - ( (24Mhz/8) / Baudrate_115200)
#define Baudrate_115200 0x03E5

// formula : (1024 - ( (24Mhz/8) / Baudrate_9600)
#define Baudrate_9600 0x02C7

// formula : (1024 - ( (24Mhz/64) / Baudrate_9600)
//#define Baudrate_9600 0x03D9

void Uart_Definition(void)
{
	PINSET6 |= 0x0A;	//TX, RX PULL UP; MOCS = 1
	PINCONG6 |= 0x01;	//RX Quasi-bidirectional
										//TX Push-pull output
	AUX = 0x04;
	PFCON = 0x30;		//[5:4] SRELPS 00:F_PER/64, 01:F_PER/32, 10:F_PER/16, 11:F_PER/8
									//[3:2] T1PS   00:F_PER/12, 01:F_PER,    10:F_PER/96
									//[1:0] T0PS   00:F_PER/12, 01:F_PER,    10:F_PER/96
	//SCON = 0x52;		//8 bit UART, enable Serial reception
	SCON = 0x42;		//8 bit UART, Disable Serial reception
									
	SRELH = Baudrate_115200 >> 8;
	SRELL = Baudrate_115200 & 0xFF;

}
//======================================================================
/*
 * Name         : UART_PACKAGE_BUILD 
 *
 * Synopsis     : void UART_PACKAGE_BUILD(void)
 *
 * Description  : Build slave package to response.
 * 
 */

void Uart_Package_Build(void)
{
	unsigned short CheckSum = 0;
	unsigned short i = 0;

	if(TxFinish == TX_FINISH)
	{
		Debug_TxBuffer[0]  = 0x28;// Start Byte : 0x28
		Debug_TxBuffer[1]  = 0x41;// MCU Cmd Byte : 0x41
		Debug_TxBuffer[2]  = 0x16;// DataType : 
		Debug_TxBuffer[3]  = 0x0C;// DataLength : 0x0C (12 Byte DataLength)
		Debug_TxBuffer[4]  = *(((unsigned char *)&Debug_A)+1);//((Debug_A) & 0xFF );
		Debug_TxBuffer[5]  = *(((unsigned char *)&Debug_A)+0);//((Debug_A>>8) & 0xFF );
		Debug_TxBuffer[6]  = *(((unsigned char *)&Debug_B)+1);
		Debug_TxBuffer[7]  = *(((unsigned char *)&Debug_B)+0);
		Debug_TxBuffer[8]  = *(((unsigned char *)&Debug_C)+1);
		Debug_TxBuffer[9]  = *(((unsigned char *)&Debug_C)+0);
		Debug_TxBuffer[10] = *(((unsigned char *)&Debug_D)+1);
		Debug_TxBuffer[11] = *(((unsigned char *)&Debug_D)+0);
		Debug_TxBuffer[12] = *(((unsigned char *)&Debug_E)+1);
		Debug_TxBuffer[13] = *(((unsigned char *)&Debug_E)+0);
		Debug_TxBuffer[14] = *(((unsigned char *)&Debug_F)+1);
		Debug_TxBuffer[15] = *(((unsigned char *)&Debug_F)+0);
		
		CheckSum = 0;
		for(i = 0;i < 16; i++)
		{
			CheckSum += Debug_TxBuffer[i];
		}

		Debug_TxBuffer[16] = ((CheckSum) & 0xFF );
		Debug_TxBuffer[17] = ((CheckSum>>8) & 0xFF );

		TxFinish = TX_SEND;
		Debug_TxDataLen = 18;

		Debug_TxCounter = 0;
		SBUF = Debug_TxBuffer[Debug_TxCounter];
		Debug_TxCounter++;
	}
}

void Uart_ReadPackage_Build(void)
{
	short Temp;
	// Check Sum Fun: it may need Checksum and the data may lose
	Uart_CheckSum_Fun();
	if(CheckSUMFlag == 1)
	{
		CheckSUMFlag = 0;
		switch(Debug_RxBuffer[2])
		{
			case 0:
			case 1:
				Temp = Debug_RxBuffer[5]<<8;
				Temp |= Debug_RxBuffer[4];
				break;
			default:
				break;
		}
	}

	Debug_RxCounter = 0;
	RxState = RX_INT;
}

void Uart_Read_Handle(void)
{
	if(RxState == RX_HANDLE)
	{
		if(Debug_PreRxCounter == Debug_RxCounter)
		{
			RxTimeOutCount += Timer1ms;
			if(RxTimeOutCount >= PeriodTime10ms)
			{
				RxState = RX_FINISH;// Debug_RxCounter is over 10ms if no status change. It means UART RX finish
			}
		}
		else
		{
			RxTimeOutCount = 0;
		}
		Debug_PreRxCounter = Debug_RxCounter;
	}
}

void Uart_Send_Buffer(void)
{
	if(TxFinish <= TX_SEND)
	{
		SBUF = Debug_TxBuffer[Debug_TxCounter];
		Debug_TxCounter++;
	}
	
	if(Debug_TxCounter >= Debug_TxDataLen)
	{
		TxFinish = TX_FINISH;
		UartFlag = 0;
	}
}

void Uart_Read_Buffer(void)
{
	RxState = RX_HANDLE;// Rx Start Flag
	Debug_RxBuffer[Debug_RxCounter] = SBUF;
	Debug_RxCounter++;// DataLen
}

void Uart_CheckSum_Fun(void)
{
	unsigned char i;
	unsigned char RxDataLen = Debug_RxBuffer[3]+4;
	unsigned short CheckSUM;
	
	CheckSUMFlag = 0;
	CheckSUM = 0;
	for(i = 0; i < RxDataLen; i++)
	{
		CheckSUM += Debug_RxBuffer[i];
	}
	
	if((Debug_RxBuffer[RxDataLen] == (CheckSUM & 0x00FF))
		&& (Debug_RxBuffer[RxDataLen+1] == (CheckSUM & 0xFF00)>>8))
	{
		CheckSUMFlag = 1;
	}
}
#endif